//////////////////////////////////////////////////////////////////////////////
//
//  Copyright 2017 Autodesk, Inc.  All rights reserved.
//
//  Use of this software is subject to the terms of the Autodesk license 
//  agreement provided at the time of installation or download, or which 
//  otherwise accompanies this software in either electronic or hard copy form.   
//
//////////////////////////////////////////////////////////////////////////////

#pragma once

#include <QtWidgets/QPushButton>

class TexmapButton : public QPushButton 
{
    Q_OBJECT

public:
    TexmapButton(QWidget* = nullptr);

    void setSmallLabel(bool = true);
    void hasMap(bool = true);
    void setConnected(bool = true);

protected:
    virtual void paintEvent(QPaintEvent * event) override;

private:
    bool m_map;
    bool m_connected;
    bool m_smallLabel;
};
